/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.Save;
import cds.aladin.Server;
import cds.tools.MultiPartPostOutputStream;
import java.awt.Dimension;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ServerSWarp
extends Server {
    private String outputProj;
    private String atLeastOne;
    private JComboBox comboProj;
    private String baseUrl = "http://aladin.cds.unistra.fr/java/post.pl";
    private String[] availableProjections = new String[]{"TAN", "SIN", "ARC", "AIT", "ZEA", "ZPN", "STG"};

    protected void init() {
        this.type = 1;
        this.aladinLabel = "SWarp image co-adding service";
        this.aladinLogo = "SWarp.gif";
        this.docUser = "http://terapix.iap.fr/rubrique.php?id_rubrique=49";
    }

    @Override
    protected void createChaine() {
        this.title = Aladin.chaine.getString("SWTITLE");
        this.description = Aladin.chaine.getString("SWINFO");
        this.outputProj = Aladin.chaine.getString("SWOUTPUTPROJ");
        this.atLeastOne = Aladin.chaine.getString("SWATLEASTONE");
        super.createChaine();
    }

    protected ServerSWarp(Aladin aladin) {
        this.aladin = aladin;
        this.createChaine();
        this.init();
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int y = 50;
        int X = 150;
        JPanel tp = new JPanel();
        Dimension d = this.makeTitle(tp, this.title);
        tp.setBackground(Aladin.BLUE);
        tp.setBounds(235 - d.width / 2, y, d.width, d.height);
        this.add(tp);
        JLabel l = new JLabel(this.description);
        l.setBounds(90, y += d.height + 10, 400, 20);
        y += 20;
        this.add(l);
        int nbCombo = 8;
        this.input = new JComponent[nbCombo];
        this.modeInput = new int[nbCombo];
        this.nbInput = nbCombo;
        for (int i = 0; i < nbCombo; ++i) {
            JLabel pTitre = new JLabel(this.addDot("Image " + (i + 1)));
            pTitre.setFont(Aladin.BOLD);
            pTitre.setBounds(10, y, 150, HAUT);
            this.add(pTitre);
            JComboBox combo = new JComboBox();
            combo.setBounds(160, y, XWIDTH - 160, HAUT);
            y += HAUT + MARGE;
            this.add(combo);
            this.input[i] = combo;
            this.modeInput[i] = 1;
        }
        y = (int)((double)y + 1.3 * (double)(HAUT + MARGE));
        JLabel pTitre = new JLabel(this.addDot(this.outputProj));
        pTitre.setBounds(10, y, 150, HAUT);
        this.add(pTitre);
        this.comboProj = new JComboBox();
        this.comboProj.setBounds(160, y, XWIDTH - 160, HAUT);
        y += HAUT + MARGE;
        this.add(this.comboProj);
        for (int i = 0; i < this.availableProjections.length; ++i) {
            this.comboProj.addItem(this.availableProjections[i]);
        }
    }

    @Override
    protected void adjustInputChoice(JComboBox c, Vector v, int defaut) {
        int i = c.getSelectedIndex();
        String s = i >= 0 ? (String)c.getItemAt(i) : null;
        c.removeAllItems();
        c.addItem(this.NOINPUTITEM);
        if (v != null) {
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                c.addItem(((Plan)e.nextElement()).label);
            }
        }
        if (defaut > 0) {
            c.setSelectedIndex(defaut);
        } else if (s == null || s.equals(this.NOINPUTITEM)) {
            c.setSelectedIndex(0);
        } else {
            c.setSelectedItem(s);
        }
    }

    @Override
    protected boolean isDiscovery() {
        return false;
    }

    private void submitThread() {
        URL url;
        this.waitCursor();
        HashSet<Plan> selectedImages = new HashSet<Plan>();
        for (int i = 0; i < this.input.length; ++i) {
            Plan[] planes = this.getInputPlane(this.input[i]);
            if (planes == null || planes.length == 0) continue;
            selectedImages.add(planes[0]);
        }
        if (selectedImages.size() == 0) {
            Aladin.error(this.atLeastOne);
            return;
        }
        Iterator it = selectedImages.iterator();
        try {
            url = new URL(this.baseUrl);
        }
        catch (MalformedURLException mue) {
            this.defaultCursor();
            mue.printStackTrace();
            return;
        }
        try {
            MultiPartPostOutputStream.setTmpDir(Aladin.CACHEDIR);
            String boundary = MultiPartPostOutputStream.createBoundary();
            URLConnection urlConn = MultiPartPostOutputStream.createConnection(url);
            urlConn.setRequestProperty("Accept", "*/*");
            urlConn.setRequestProperty("Content-Type", MultiPartPostOutputStream.getContentType(boundary));
            urlConn.setRequestProperty("Connection", "Keep-Alive");
            urlConn.setRequestProperty("Cache-Control", "no-cache");
            MultiPartPostOutputStream out = new MultiPartPostOutputStream(urlConn.getOutputStream(), boundary);
            out.writeField("projection", this.comboProj.getSelectedItem().toString());
            if (this.aladin.save == null) {
                this.aladin.save = new Save(this.aladin);
            }
            int imgIdx = 1;
            while (it.hasNext()) {
                String paramName = "img" + imgIdx;
                Plan p = (Plan)it.next();
                if (p.hasRemoteUrl()) {
                    out.writeField(paramName, p.getUrl());
                } else {
                    out.writeFile(paramName, "image/fits", paramName + ".fits", this.aladin.save.saveImageFITS((OutputStream)null, (PlanImage)p), true);
                }
                ++imgIdx;
            }
            out.close();
            this.aladin.calque.newPlanImage(urlConn.getInputStream(), "SWarp", "SWarp");
        }
        catch (Exception ioe) {
            this.defaultCursor();
            ioe.printStackTrace();
            Aladin.error("An error occured while contacting the SWarp service");
            return;
        }
        this.defaultCursor();
    }

    @Override
    public void submit() {
        new Thread(){

            @Override
            public void run() {
                ServerSWarp.this.submitThread();
            }
        }.start();
    }
}

